####################################################
### code chunk number : Simulations: Marginal density, alpha = 4, beta = 2, v = 2
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
set.seed(1)
alpha = 4            ## hyperparameter
beta = 2             ## hyperparameter
v = 2                ## hyperparameter

x = seq(0.01, 10, by = 0.01)
md = Marginal_density_alpha_beta_v(x, alpha, beta, v)

dev.new()
col = 1:1
lty = 1:1
xlim = range(x); xlim
ylim = range(md); ylim
plot(x, md, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md,  lty = lty[1], col = col[1], lwd = 4)
# title(Title)
leg.txt = "alpha = 4, beta = 2, v = 2"
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
# savePlot(filename = paste("figure/md_x", sep=""), type = c("pdf"))


####################################################
### code chunk number : Simulations: Marginal density, alpha = 4, 5, 7, 12
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = c(4, 5, 7, 12) ## hyperparameter
beta = 2               ## hyperparameter
v = 2                  ## hyperparameter

x = seq(0.01, 10, by = 0.01)
md1 = Marginal_density_alpha_beta_v(x, alpha = alpha[1], beta, v); 
md2 = Marginal_density_alpha_beta_v(x, alpha = alpha[2], beta, v); 
md3 = Marginal_density_alpha_beta_v(x, alpha = alpha[3], beta, v); 
md4 = Marginal_density_alpha_beta_v(x, alpha = alpha[4], beta, v); 

dev.new()
col = c("black", "red", "blue", "purple")
lty = 1:4
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(alpha, " = 4", sep = "")),
expression(paste(alpha, " = 5", sep = "")),
expression(paste(alpha, " = 7", sep = "")),
expression(paste(alpha, " = 12", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/G-G_md_x_alpha_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/G-G_md_x_alpha_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, beta = 1, 2, 4, 8
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 4             ## hyperparameter
beta = c(1, 2, 4, 8)  ## hyperparameter
v = 2                 ## hyperparameter

x = seq(0.01, 10, by = 0.01)
md1 = Marginal_density_alpha_beta_v(x, alpha, Beta = beta[1], v); 
md2 = Marginal_density_alpha_beta_v(x, alpha, Beta = beta[2], v); 
md3 = Marginal_density_alpha_beta_v(x, alpha, Beta = beta[3], v); 
md4 = Marginal_density_alpha_beta_v(x, alpha, Beta = beta[4], v); 

dev.new()
col = c("black", "red", "blue", "purple")
lty = 1:4
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(beta, " = 1", sep = "")),
expression(paste(beta, " = 2", sep = "")),
expression(paste(beta, " = 4", sep = "")),
expression(paste(beta, " = 8", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/G-G_md_x_beta_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/G-G_md_x_beta_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, v = 1, 2, 4, 8
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 4          ## hyperparameter
beta = 2           ## hyperparameter
v = c(1, 2, 4, 8)  ## hyperparameter

x = seq(0.01, 10, by = 0.01)
md1 = Marginal_density_alpha_beta_v(x, alpha, beta, v = v[1]); 
md2 = Marginal_density_alpha_beta_v(x, alpha, beta, v = v[2]); 
md3 = Marginal_density_alpha_beta_v(x, alpha, beta, v = v[3]); 
md4 = Marginal_density_alpha_beta_v(x, alpha, beta, v = v[4]); 

dev.new()
col = c("black", "red", "blue", "purple")
lty = 1:4
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 4)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 4)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 4)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 4)
# title(Title)
leg.txt = c(
expression(paste(nu, " = 1", sep = "")),
expression(paste(nu, " = 2", sep = "")),
expression(paste(nu, " = 4", sep = "")),
expression(paste(nu, " = 8", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/G-G_md_x_v_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/G-G_md_x_v_changes", sep=""), type = c("jpg"))

